	function [L, C, K] = X_CAUER_II(Xnum, Xden)
	
	% 	Computes the element values in a Cauer II realization of a reactance using
	%	a Continued Fraction Expansion. Even-order reactances are terminated 
	%	with a short-circuit.
	%
	%							1
	%	X(s) = 1/L1s + --------------------------
	% 			     1/C2s +            1
	%                      _______________________
	%				      	1/L3s +     1
	%				     		 ----------------
	%						       1/C4s +......
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2007-06-15
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	%	To improve:		Check that X is a true reactance function	
	
	%	Example: X(s) = (8s + 6s^3 + s^5)/(3 + 4s^2 +s^4)
	%			 Xnum = [0 8 0 6 0 1] and Xden = [3 0 4 0 1]
 
	a = Xnum; a(1:2:end) = Xden(1:2:end);
	N = length(Xnum)-1; 
	 k=1;	 
	for u = 1:N+1
		Q(k) = a(k)/a(k+1);
		m = k+2;
		if m > N+1, break; end
		for p = m:2:N
			a(p) = a(p)-Q(k)*a(p+1);
		end
		k = k+1;
	end
	Q = 1./Q;
	L = zeros(1,N); 	L(1:2:end) = Q(1:2:end);
	C = zeros(1,N); 	C(2:2:end) = Q(2:2:end);
	K = 8*ones(1,N);	K(2:2:end) = 3;
	if mod(N,2)
		disp(['Short-circuited termination'])
	end
  
